package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.biz.GroupTask;
import gov.va.vinci.dart.biz.Task;
import gov.va.vinci.dart.db.GroupTaskDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

public class GroupTaskDAOImpl extends HibernateDAO implements GroupTaskDAO {

	@Override
	public void save(final GroupTask groupTask) {
		if (groupTask == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(groupTask);
	}
	
	@Override
	public void delete(GroupTask task) {
		if (task == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(task);
	}	
	
	@Override
	@SuppressWarnings("unchecked")
	public List<GroupTask> listByOwner(final int ownerId) {
		Query query = createQuery("from GroupTask where groupOwner.id=:oid");
		query.setParameter("oid", ownerId);
		return (List<GroupTask>)query.getResultList();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<GroupTask> listOpenByOwner(final int ownerId) {
		Query query = createQuery("from GroupTask where groupOwner.id=:oid and completedOn is null");	//not yet completed
		query.setParameter("oid", ownerId);
		return (List<GroupTask>)query.getResultList();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<GroupTask> listOpenByOwnerAndRequestId(final int ownerId, final int requestId) {
		Query query = createQuery("from GroupTask where groupOwner.id=:oid and request.id=:rid and completedOn is null");	//not yet completed
		query.setParameter("rid", requestId);
		query.setParameter("oid", ownerId);
		return (List<GroupTask>)query.getResultList();
	}
	
	@SuppressWarnings("unchecked")
	public List<GroupTask> listOpenByWorkflowAndOwnerAndRequestId(final int workflowId, final int ownerId, final int requestId) {
		Query query = createQuery("from GroupTask where groupOwner.id=:oid and request.id=:rid and completedOn is null and (workflow is not null and workflow.id=:wid)");	//not yet completed
		query.setParameter("wid", workflowId);
		query.setParameter("oid", ownerId);
		query.setParameter("rid", requestId);
		return (List<GroupTask>)query.getResultList();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<GroupTask> listByOwnerAndRequestId(final int ownerId, final int requestId) {
		Query query = createQuery("from GroupTask where groupOwner.id=:oid and request.id=:rid");	//get all GroupTasks for this request and this group, even if those tasks are closed		
		query.setParameter("rid", requestId);
		query.setParameter("oid", ownerId);
		return (List<GroupTask>)query.getResultList();
	}	
	
	@Override
	@SuppressWarnings("unchecked")
	public List<GroupTask> listAllGroupTasks() {
		Query query = createQuery("from GroupTask");

		try {
			return (List<GroupTask>)query.getResultList();
		} catch (NoResultException e) {
			return new ArrayList<GroupTask>();
		}
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<GroupTask> listAllOpenGroupTasks() {
		Query query = createQuery("from GroupTask and completedOn is null");	//not yet completed

		try {
			return (List<GroupTask>)query.getResultList();
		} catch (NoResultException e) {
			return new ArrayList<GroupTask>();
		}
	}
	
	@Override
	public GroupTask findById(int taskId) {
		Query query = createQuery("from GroupTask where id=:tid");
		query.setParameter("tid", taskId);
		return (GroupTask)query.getSingleResult();
	}	

}
